#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Live-coding #1_Continuum 1Mod01.fsh   by   lsdlive
//https://www.shadertoy.com/view/4ddfDr
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// @lsdlive

// Live-coding session I did for a rap music set last week end.
// This is the part 1 of the shader session, this was prepared before the show.
// The code below is almost the code that was on stage at the mid-show,
// ported from atom-veda to shadertoy.

// Several code snippets you will find, as it or revisited, in this shader:
// * aiekick's phantom mode - https://www.shadertoy.com/view/MtScWW
// * balkhan's glow - https://www.shadertoy.com/view/4t2yW1
// * lj's short octahedron formula - "float od = dot(q, normalize(sign(q))) - .15;"
// * iq & mercury's hglib sdf functions
// https://iquilezles.org/articles/distfunctions
// http://mercury.sexy/hg_sdf/
// * iq's signed cross sc() - https://iquilezles.org/articles/menger

// Thanks to shadertoy community & shader showdown paris, making this possible.

// This is under CC-BY-NC-SA (shadertoy default licence)


mat2 r2d(float a) {
	float c = cos(a), s = sin(a);
	return mat2(c, s, -s, c);
}

float sc(vec3 p, float d) {
	p = abs(p);
	p = max(p, p.yzx);
	return min(p.x, min(p.y, p.z)) - d;
}

float rep(float p, float d) {
	return mod(p - d*.5, d) - d*.5;
}

vec3 rep(vec3 p, float d) {
	return mod(p - d*.5, d) - d*.5;
}

float dt = 0.;
float g = 0.;
float de(vec3 p) {

	vec3 q = p;
	float t = iTime*8.6*2.;
	float s = t*.1 + sin(t)*.1;
	q.xy += vec2(cos(iTime)*sin(iTime)*.3, sin(iTime)*.3);
	q.z -= dt + sin(iTime);
	q.xz *= r2d(iTime);
	q.xy *= r2d(iTime);
	float od = dot(q, normalize(sign(q))) - .15;

	float pl = p.y + .6;

	q = p;
	//q.y+=.2;
	q.x += sin(q.z + iTime)*.6;
	q.y += cos(q.z + iTime*2.)*.6;
	float cyl = length(q.xy) - .02;

	q = p;
	q += iTime*.2;
	q.xy += sin(q.z*.4)*2.;
	q = rep(q, 1.);
	float s1 = length(q) - .002 + sin(iTime*30.)*.002;


	p.z = rep(p.z, 2.);

	float sc2 = sc(p, .4);

	p.x = abs(p.x) - 2.;
	p.xy *= r2d(3.14*.25);
	float sc1 = sc(p, .3);

	float d = min(sc1, pl);
	d = max(d, -sc2);
	d = min(d, od);
	d = min(d, cyl);
	d = min(d, s1);

	g += .01 / (.01 + d*d);
	return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord / iResolution.xy - .5;
	uv.x *= iResolution.x / iResolution.y;

	dt = iTime*2.;

	vec3 ro = vec3(0, 0, -3. + dt);
	vec3 ta = vec3(0, 0, 0. + dt);
	vec3 fwd = normalize(ta - ro);
	vec3 left = cross(vec3(0, 1, 0), fwd);
	vec3 up = cross(fwd, left);
	vec3 rd = normalize(fwd + left*uv.x + up*uv.y);

	//rd.xy *= r2d(sin(iTime*.5)*.3);

	vec3 p;
	float t = 0., ri;
	for (float i = 0.; i < 1.; i += .01) {
		ri = i;
		p = ro + rd*t;
		float d = de(p);
		//if (d < .001) break;
		d = max(abs(d), .0002);
		t += d*.3;
	}

	vec3 c = mix(vec3(.6, .3, .3), vec3(0), abs(p.x*p.y) + ri);
	c += g*.01;
	fragColor = vec4(c, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

